;**************************************
; Test LCD Type Character 
; Hardware  : CP-PIC V3.0/4.0 (18F458)
; OSC   10 MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 28/7/2002
;**************************************

     list p=18f458                 ; list directive to define processor
     #include <p18f458.inc>        ; processor specific variable definitions

#define   RS        PORTC,0        ; RS Bit LCD
#define   E         PORTA,4        ; Enable Bit LCD

com       EQU       0x20           ; buffer for Instruction
dat       EQU       0x21           ; buffer for data
count1    EQU       0x22
count2    EQU       0x23
count3    EQU       0x24
count16   EQU	    0x25
index	  EQU	    0x26

          ORG       0x0000

;************ initial *******************
	  
          clrf      TRISA          ; All port A is output
	  clrf	    TRISC	   ; All port C is output
	  clrf	    TRISD	   ; All port D is output
	  setf	    PORTD	   ; Hi PORT D
	  call	    delay	   ; wait LCD 
	  call	    delay

          movlw     B'00110011'    
          call      WR_INS
          movlw     B'00110010'
          call      WR_INS
          movlw     B'00101000'    ; 4 bits, 2 lines,5X7 dot 
          call      WR_INS
          movlw     B'00001100'    ; display on/off
          call      WR_INS
          movlw     B'00000110'    ; Entry mode
          call      WR_INS	   
          movlw     B'00000001'    ; Clear ram
          call      WR_INS
	  
	  clrf	    index	   ; start index = 00
SEND	  movf	    index,w
	  call	    TAB		   ; recive data from table
	  addlw     0              ; Character = 00 ?
          btfsc     STATUS,Z       ; Character = 00 ?
          goto      $              ; Yes , Z = 1
          call	    WR_DATA        ; No  , Z = 0
	  call	    delay
	  incf	    index,f	   ; inc Pointer
	  incf	    index,f
	  goto	    SEND	         
	  

	 

;****************************************
; Write command to LCD
; Input  : W
; output : -
;****************************************
WR_INS    bcf       RS        ; clear RS
 	  bsf	    E
          movwf     com       ; W --> com
          andlw     0xF0      ; mask 4 bits MSB  W = X0        
          movwf     PORTD     ; Send 4 bits MSB
          bcf       E         ; 
          call      delay     ; __    __      
          bsf       E         ;   |__|
          swapf     com,w
          andlw     0xF0      ; 1111 0010
          movwf     PORTD     ; send 4 bits LSB
          bcf       E         ;
          call      delay     ; __    __      
          bsf       E         ;   |__|
          call      delay
          return

;***************************************
; Write data to LCD
; Input  : W
; Output : -
;***************************************
WR_DATA   bsf       RS	      ; RS = 1 is send Data 
	  bsf	    E	      ; Pulse Hi
          movwf     dat       
          andlw     0xF0      ; Mask lower 4 bits    
          movwf     PORTD     ; send data to LCD
          bcf       E         ; Pulse Low
          call      delay     ; __    __
          bsf       E         ;   |__|
          swapf     dat,w     ; 
          andlw     0xF0      ; Mask lower 4 bits
          movwf     PORTD     ; send data to LCD
          bcf       E         ; Pulse Low
          call      delay     ; __    __
          bsf       E         ;   |__|
          return


;***************************************
; Delay 
;***************************************
delay     movlw     .100
          movwf     count1
del1      clrf      count2
del2      decfsz    count2
          goto      del2
          decfsz    count1
          goto      del1
          return

TAB	  addwf	   PCL
	  DT	   "PIC 18F458",0x0	
          END

